#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/chrono/include/time_point.h>
#include <yandex/maps/wiki/social/common.h>

#include <pqxx/pqxx>
#include <optional>
#include <set>
#include <string>
#include <map>
#include <vector>

namespace maps::wiki::social::feedback {

const std::string HISTORY_PARAM_OLD_TYPE = "oldType";
const std::string HISTORY_PARAM_NEW_TYPE = "newType";
const std::string HISTORY_PARAM_OLD_POSITION = "oldPosition";
const std::string HISTORY_PARAM_NEW_POSITION = "newPosition";
const std::string HISTORY_PARAM_REJECT_REASON = "reason";
const std::string HISTORY_PARAM_TEMPLATE = "template";
const std::string HISTORY_PARAM_SUGGESTED_VERDICT = "resolution";
const std::string HISTORY_PARAM_NEW_PROCESSING_LVL = "newProcessingLvl";

enum class TaskOperation
{
    Create,
    Defer,
    Reveal,
    Open,
    NeedInfo,
    Acquire,
    Release,  // == unAcquire
    Accept,
    Reject,
    Deploy,
    Comment,
    Hide,
    Show,
    ChangeType,
    ChangePosition,
    MarkViewed,
    ProcessingLevelUp,
    ProcessingLevelDown,
    ChangeProcessingLvl,

    // this value means we read operation not supported by current version of lib/social
    Unrecognized
};

DECLARE_ENUM_IO(TaskOperation);

using TaskOperations = std::set<TaskOperation>;
using HistoryItemParams = std::map<std::string, std::string>;

class HistoryItem
{
public:
    HistoryItem(
        chrono::TimePoint modifiedAt,
        TUid modifiedBy,
        TaskOperation operation,
        HistoryItemParams params,
        std::optional<TId> commentId)
        : modifiedAt_(modifiedAt)
        , modifiedBy_(modifiedBy)
        , operation_(operation)
        , params_(std::move(params))
        , commentId_(commentId)
    {}

    chrono::TimePoint modifiedAt() const { return modifiedAt_; }
    TUid modifiedBy() const { return modifiedBy_; }
    TaskOperation operation() const { return operation_; }
    const HistoryItemParams& params() const { return params_; }
    std::optional<TId> commentId() const { return commentId_; }
    std::optional<TId> id() const { return id_; }

    void setId(const std::optional<TId>& id) { id_ = id; }

private:
    chrono::TimePoint modifiedAt_;
    TUid modifiedBy_;
    TaskOperation operation_;
    HistoryItemParams params_;
    std::optional<TId> commentId_;
    std::optional<TId> id_;
};

using HistoryItems = std::vector<HistoryItem>;

class History
{
public:
    History() = default;
    explicit History(HistoryItems orderedItems);

    const HistoryItems& items() const;
    std::optional<HistoryItem> lastItemWith(TaskOperation operation) const;

private:
    HistoryItems items_;
};

} //namespace maps::wiki::social::feedback
