#pragma once
#include "enums.h"
#include "history.h"

namespace maps::wiki::social::feedback {

class HistoryItemNew
{
public:
    static HistoryItemNew create(
        TUid modifiedBy,
        TaskOperation operation,
        std::optional<TId> commentId = std::nullopt);

    static HistoryItemNew createProcessingLevelUp(
        TUid modifiedBy,
        Verdict suggestedVerdict);

    static HistoryItemNew createRejected(
        TUid modifiedBy,
        std::optional<RejectReason> rejectReason,
        std::optional<TId> commentId = std::nullopt);

    static HistoryItemNew createNeedInfo(
        TUid modifiedBy,
        std::optional<std::string> requestTemplate,
        std::optional<TId> commentId);

    static HistoryItemNew createChangeType(
        TUid modifiedBy,
        Type oldType,
        Type newType);

    static HistoryItemNew createChangeProcessingLvl(
        TUid modifiedBy,
        ProcessingLvl newLvl,
        std::optional<Verdict> suggestedVerdict
    );

    static HistoryItemNew createChangePosition(
        TUid modifiedBy,
        const geolib3::Point2& oldPositionGeo,
        const geolib3::Point2& newPositionGeo);

    TUid modifiedBy() const { return modifiedBy_; };
    TaskOperation operation() const { return operation_; }
    const HistoryItemParams& params() const { return params_; }
    std::optional<TId> commentId() const { return commentId_; }

private:
    HistoryItemNew(
        TUid modifiedBy,
        TaskOperation operation,
        HistoryItemParams params,
        std::optional<TId> commentId = std::nullopt);

    TUid modifiedBy_;
    TaskOperation operation_;
    HistoryItemParams params_;
    std::optional<TId> commentId_;
};

class TaskForUpdate;
class TaskPatch;

class HistoryPatch
{
public:
    const std::vector<HistoryItemNew>& items() const { return items_; }

    static HistoryPatch patchOnCreate(TUid uid);
    static HistoryPatch patchOnRelease(TUid uid);
    static HistoryPatch patchEmpty();
    static HistoryPatch patchOnUpdate(
        const TaskForUpdate& task,
        const TaskPatch& patch);

private:
    explicit HistoryPatch(std::vector<HistoryItemNew> items);

    std::vector<HistoryItemNew> items_;
};

} //namespace maps::wiki::social::feedback
