#pragma once

#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/enums.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/task_filter.h>

#include <pqxx/pqxx>
#include <optional>
#include <vector>
#include <set>

namespace maps::wiki::social::feedback {

/*
 * Filter to get distinct source from materialized view.
 * Bucket is supposed to be NOT IN ['incoming', 'deferred']
*/

class MvSourceTypeFilter {
public:
    std::string whereClause() const;

    MvSourceTypeFilter& status(std::optional<UIFilterStatus> status);
    MvSourceTypeFilter& hidden(std::optional<bool> hidden);
    MvSourceTypeFilter& sources(std::optional<std::vector<std::string>> sources);
    MvSourceTypeFilter& types(std::optional<Types> types);
    MvSourceTypeFilter& ageTypes(std::optional<AgeTypes> ageTypes);
    MvSourceTypeFilter& workflows(std::optional<Workflows> workflows);
    MvSourceTypeFilter& addBaseDimensions(BaseDimensions baseDimensions);

private:
    std::optional<UIFilterStatus> status_;
    std::optional<bool> hidden_;
    std::optional<Types> types_;
    std::optional<std::vector<std::string>> sources_;
    std::optional<AgeTypes> ageTypes_;
    std::optional<Workflows> workflows_;
    std::vector<BaseDimensions> baseDimensionsArray_;
};

std::set<std::string>
mvSourcesByFilter(
    pqxx::transaction_base& socialTxn,
    const MvSourceTypeFilter& filter);

Types
mvTypesByFilter(
    pqxx::transaction_base& socialTxn,
    const MvSourceTypeFilter& filter);

void refreshSourceTypeMv(pqxx::transaction_base& socialTxn);

} // namespace maps::wiki::social::feedback
