#pragma once

#include <yandex/maps/wiki/social/feedback/task.h>

#include <string>
#include <vector>

namespace maps::wiki::social::feedback {

enum class Partition
{
    Pending,
    OutgoingOpened,
    OutgoingOpenedExperiment,
    OutgoingClosed
};

const std::vector<Partition>& allPartitions();

std::string feedbackPartitionTable(Partition partition);
std::string aoiFeedbackFeedPartitionTable(Partition partition);

Partition getPartition(const Task& task);

} // namespace maps::wiki::social::feedback
