#pragma once

#include <maps/libs/common/include/exception.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/introspection/include/stream_output.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/enums.h>
#include <yandex/maps/wiki/social/common.h>

#include <pqxx/pqxx>
#include <optional>
#include <vector>
#include <tuple>

namespace maps::wiki::social::feedback {

using maps::introspection::operator==;
using maps::introspection::operator<<;

class TaskFilter;
class BaseDimensions;

enum class RoleKind {
    Read,
    AllRights,
};
DECLARE_ENUM_IO(RoleKind);

struct PresetEntries {
    std::optional<std::vector<Type>> types;
    std::optional<std::vector<Workflow>> workflows;
    std::optional<std::vector<std::string>> sources;
    std::optional<std::vector<AgeType>> ageTypes;
    std::optional<bool> hidden;
    std::optional<UIFilterStatus> status;

    auto introspect() const {
        return std::tie(
            types,
            workflows,
            sources,
            ageTypes,
            hidden,
            status
        );
    }
};

class PresetRoles {
public:
    PresetRoles() = default;

    void setId(RoleKind kind, TId id);
    TId getId(RoleKind kind) const;
    bool hasAllRoles() const;

    auto introspect() const {
        return roleSet_;
    }

private:
    std::map<RoleKind, TId> roleSet_;
};

struct NewPreset {
    std::string name;
    PresetRoles roles;
    PresetEntries entries;

    auto introspect() const {
        return std::tie(name, roles, entries);
    }
};

struct Preset {
    TId id;
    std::string name;
    PresetRoles roles;
    PresetEntries entries;

    auto introspect() const {
        return std::tie(id, name, roles, entries);
    }

    BaseDimensions getBaseDimensions() const;
};

using Presets = std::vector<Preset>;


Presets getPresets(
    pqxx::transaction_base& socialTxn);

std::optional<Preset> getPreset(
    pqxx::transaction_base& socialTxn,
    TId presetId);

struct FeedbackPresetError     : public RuntimeError {};
struct CreateNoRolePresetError : public FeedbackPresetError {};
struct PresetDoesntExistError  : public FeedbackPresetError {};
struct UniquePresetNameError   : public FeedbackPresetError {};
struct UpdatePresetRoleError   : public FeedbackPresetError {};

Preset addPreset(
    pqxx::transaction_base& socialTxn,
    const NewPreset& newPreset);

void updatePreset(
    pqxx::transaction_base& socialTxn,
    const Preset& preset);

void deletePreset(
    pqxx::transaction_base& socialTxn,
    uint64_t presetId);

} // namespace maps::wiki::social::feedback
