#pragma once

#include <yandex/maps/wiki/social/common.h>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/libs/geolib/include/polygon.h>

#include <optional>
#include <pqxx/pqxx>
#include <vector>
#include <memory>

namespace maps::wiki::social::feedback {

namespace tests {
    class FbReviewFactory;
} // namespace tests

class ReviewDoesntExist : public maps::Exception {};
class InvalidReviewOperation : public maps::Exception {};
class AnotherReviewInProgress : public InvalidReviewOperation {};
class NothingToReview : public InvalidReviewOperation {};

enum class ReviewState {
    Draft,
    Published
};

class ReviewBrief {
public:
    TId id() const { return id_; }
    ReviewState state() const { return state_; }
    chrono::TimePoint createdAt() const { return createdAt_; }
    TUid createdBy() const { return createdBy_; }
    std::optional<chrono::TimePoint> publishedAt() const { return publishedAt_; }
    TUid reviewee() const { return reviewee_; }
    TId regionId() const { return regionId_; }
    TId regionCommitId() const { return regionCommitId_; };
    const std::string& reportData() const { return reportData_; }
    const std::string& comment() const { return comment_; }

protected:
    friend class ReviewsGateway;

    ReviewBrief(
        TId id,
        ReviewState state,
        TUid createdBy,
        TUid reviewee,
        TId regionId,
        TId regionCommitId);
    explicit ReviewBrief(const pqxx::row& row);

    TId id_;
    ReviewState state_;
    chrono::TimePoint createdAt_;
    TUid createdBy_;
    std::optional<chrono::TimePoint> publishedAt_;
    TUid reviewee_;
    TId regionId_;
    TId regionCommitId_;
    std::string reportData_;
    std::string comment_;
};

struct ReviewTaskComment
{
    enum class Topic {
        BadPhoto,
        MissingObjects,
        Other,
        UnwantedObjects
    };
    std::optional<Topic> topic;
    std::string comment;
};

class Review : public ReviewBrief {
public:
    const std::map<TId, ReviewTaskComment>& tasksComments() const { return tasksComments_; };
    void setPublished(const std::string& reportData);
    void setComment(const std::string& comment);
    void setTaskComment(TId taskId, const std::string& comment, std::optional<ReviewTaskComment::Topic> topic);

private:
    friend class ReviewsGateway;
    friend class tests::FbReviewFactory;

    using ReviewBrief::ReviewBrief;
    std::map<TId, ReviewTaskComment> tasksComments_;
};

DECLARE_ENUM_IO(ReviewState);
DECLARE_ENUM_IO(ReviewTaskComment::Topic);
} // namespace maps::wiki::social::feedback
