#pragma once

#include <yandex/maps/wiki/social/feedback/review.h>
#include <yandex/maps/wiki/social/common.h>

#include <optional>
#include <pqxx/pqxx>
#include <vector>
#include <memory>

namespace maps::wiki::social::feedback {

class ReviewsGateway
{
public:
    enum class CreationPolicy {
        NewTasks,
        AllTasks
    };

    explicit ReviewsGateway(pqxx::transaction_base& socialTxn);

    Review createReview(
        TId regionId,
        TId regionCommitId,
        TUid reviewee,
        TUid author,
        const geolib3::Polygon2& regionGeom,
        CreationPolicy creationPolicy);

    Review getReview(TId reviewId);
    std::vector<ReviewBrief> getRecentRegionReviews(TId regionId, size_t limit);
    Review saveReview(const Review& review);
    void deleteReview(TId reviewId);
    
private:
    pqxx::transaction_base& socialTxn_;
};
} // namespace maps::wiki::social::feedback
