#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/social/comment.h>
#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/feedback/attributes.h>
#include <yandex/maps/wiki/social/feedback/enums.h>
#include <yandex/maps/wiki/social/feedback/description.h>
#include <yandex/maps/wiki/social/feedback/history.h>
#include <yandex/maps/wiki/social/feedback/task_brief.h>

#include <optional>
#include <pqxx/pqxx>
#include <vector>

namespace maps::wiki::social::feedback {

class Task : public TaskBrief
{
public:
    Task(
        const pqxx::row& row,
        const std::string& tablePrefix = "");

    const Description& description() const;
    const Attrs& attrs() const;

    std::optional<std::string> subSource() const;

private:
    friend tests::FbTaskFactory;
    Task() = default;

    Description description_;
    Attrs attrs_;
};

class TaskForUpdate : public Task
{
public:
    TaskForUpdate(
        const pqxx::row& row,
        const std::string& tablePrefix = ""
    ) : Task(row, tablePrefix) {}
};

using Tasks = std::vector<Task>;
using TasksForUpdate = std::vector<TaskForUpdate>;

social::Comments loadRelativeComments(
    pqxx::transaction_base& txn,
    const HistoryItems& historyEvents);

} // namespace maps::wiki::social::feedback
