#pragma once

#include "task_feed.h"
#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/feedback/partition.h>
#include <yandex/maps/wiki/social/feedback/task_filter.h>
#include <pqxx/pqxx>
#include <optional>

namespace maps::wiki::social::feedback {

class AoiTaskFilter {
public:
    std::string whereClause() const;

    AoiTaskFilter& types(std::optional<Types> types);
    AoiTaskFilter& workflows(std::optional<Workflows> workflows);
    AoiTaskFilter& sources(std::optional<std::vector<std::string>> sources);

private:
    std::optional<Types> types_;
    std::optional<Workflows> workflows_;
    std::optional<std::vector<std::string>> sources_;
};

void removeTaskFromAoiFeed(pqxx::transaction_base& socialTxn, TId taskId);

void addTaskToAoiFeed(
    pqxx::transaction_base& socialTxn,
    TId taskId,
    const TIds& aoiIds,
    Partition partition);


struct AoiTaskCounters
{
    uint64_t old = 0;
    uint64_t total = 0;
};

using AoiToTaskCounters = std::map<TId, AoiTaskCounters>;

AoiToTaskCounters calcAoiTaskCounters(
    pqxx::transaction_base& socialTxn,
    const TIds& aoiIds,
    const TaskFilter& filter,
    Partition partition);

using TaskIdToAoiIds = std::map<TId, TIds>;

TaskIdToAoiIds getTasksAoiIds(
    pqxx::transaction_base& socialTxn, const TIds& taskIds);

struct AoiTaskStatCounters
{
    uint64_t old = 0;
    uint64_t oldHidden = 0;
    uint64_t total = 0;
    uint64_t totalHidden = 0;
};

using AoiToTaskStatCounters = std::map<TId, AoiTaskStatCounters>;

AoiToTaskStatCounters calcAoiOpenedTaskStatCounters(
    pqxx::transaction_base& socialTxn,
    const TIds& aoiIds,
    const AoiTaskFilter& filter);


using AoiToOptionalTask = std::map<TId, std::optional<Task>>;

// not real-time, uses materialized view
AoiToOptionalTask calcAoiOldestOpenedTask(
    pqxx::transaction_base& socialTxn,
    const TIds& aoiIds,
    const AoiTaskFilter& filter);

TaskFeed aoiTaskFeed(
    pqxx::transaction_base& socialTxn,
    TId aoiId,
    const ITaskFeedParams& feedParams,
    const TaskFilter& filter,
    const std::set<Partition>& partitions);

void refreshAoiOldestTaskMv(pqxx::transaction_base& socialTxn);
void refreshAoiTaskStatMv(pqxx::transaction_base& socialTxn);

} // namespace maps::wiki::social::feedback
