#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/social/comment.h>
#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/feedback/attributes.h>
#include <yandex/maps/wiki/social/feedback/enums.h>
#include <yandex/maps/wiki/social/feedback/description.h>
#include <yandex/maps/wiki/social/feedback/history.h>

#include <optional>
#include <pqxx/pqxx>
#include <vector>

namespace maps::wiki::social::feedback {

namespace tests {
    class FbTaskFactory;
} // namespace tests

class TaskPatch;

struct TaskAcquired
{
    TUid uid;
    chrono::TimePoint date;
};

class TaskBrief;

class Resolution {
public:
    static Resolution createAccepted();
    static Resolution createRejected(std::optional<RejectReason> rejectReason);

    Verdict verdict() const { return verdict_; }
    const std::optional<RejectReason>& rejectReason() const { return rejectReason_; }

    bool operator==(const Resolution& other) const;

    friend TaskBrief;

private:
    Resolution(Verdict verdict, std::optional<RejectReason> rejectReason);

    Verdict verdict_;
    std::optional<RejectReason> rejectReason_;
};

struct TaskResolved
{
    TUid uid;
    chrono::TimePoint date;
    Resolution resolution;
};

class TaskBrief
{
public:
    TaskBrief(
        const pqxx::row& row,
        const std::string& tablePrefix = ""
    );
    virtual ~TaskBrief() = default;

    TId id() const;
    chrono::TimePoint createdAt() const;
    const geolib3::Point2& position() const;
    const std::string& indoorLevel() const;
    Type type() const;
    Workflow workflow() const;
    Bucket bucket() const;
    const std::string& source() const;
    const std::optional<TaskAcquired>& acquired() const;
    virtual const std::optional<TaskResolved>& resolved() const;
    const std::optional<chrono::TimePoint>& deployedAt() const;
    const std::optional<TId>& objectId() const;
    bool hidden() const;
    bool internalContent() const;
    bool revealed() const;
    std::string hashValue() const;
    const std::optional<TId>& duplicateHeadId() const;
    const TUids& viewedBy() const;
    chrono::TimePoint stateModifiedAt() const;
    virtual int processingLevel() const;
    virtual ProcessingLvl processingLvl() const;
    virtual TaskState state() const;
    TaskState state(const TaskPatch& patch) const;

    AgeType ageType() const;

protected:
    friend class tests::FbTaskFactory;
    TaskBrief() = default;

private:
    TId id_;
    chrono::TimePoint createdAt_;
    geolib3::Point2 position_;
    std::string indoorLevel_;
    Type type_;
    Bucket bucket_;
    std::string source_;
    bool hidden_;
    bool internalContent_;
    std::optional<TaskAcquired> acquired_;
    std::optional<TaskResolved> resolved_;
    std::optional<chrono::TimePoint> deployedAt_;
    std::optional<TId> objectId_;
    std::string hashValue_;
    std::optional<TId> duplicateHeadId_;
    TUids viewedBy_;
    chrono::TimePoint stateModifiedAt_;
    ProcessingLvl processingLvl_;
};

using TasksBrief = std::vector<TaskBrief>;

} // namespace maps::wiki::social::feedback
