#pragma once

#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/feedback/attributes.h>
#include <yandex/maps/wiki/social/feedback/description.h>
#include <yandex/maps/wiki/social/feedback/enums.h>

#include <optional>

namespace maps::wiki::social::feedback {

struct TaskNew
{
    TaskNew(
        geolib3::Point2 positionMercator,
        Type type,
        std::string source,
        Description description);

    geolib3::Point2 position;
    Type type;
    std::string source;
    Description description;
    Attrs attrs;
    std::optional<std::string> indoorLevel;
    std::optional<TId> objectId;
    std::optional<bool> hidden;
    std::optional<bool> internalContent;
    std::optional<ExternalReferenceId> externalReferenceId;
};

} // namespace maps::wiki::social::feedback
