#pragma once

#include <yandex/maps/wiki/social/comments_feed.h>
#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/event_alert.h>
#include <yandex/maps/wiki/social/feed.h>
#include <yandex/maps/wiki/social/moderation_console.h>
#include <yandex/maps/wiki/social/region_feed.h>
#include <yandex/maps/wiki/social/skills.h>
#include <yandex/maps/wiki/social/subscription_console.h>
#include <yandex/maps/wiki/social/super_moderation_console.h>
#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/social/task_feed.h>
#include <yandex/maps/wiki/social/task_filter.h>
#include <yandex/maps/wiki/social/task_stats_console.h>
#include <yandex/maps/wiki/social/user_data.h>

#include <maps/libs/chrono/include/days.h>
#include <maps/libs/chrono/include/time_point.h>

#include <optional>
#include <vector>

namespace maps::wiki::social {

class Gateway
{
public:
    explicit Gateway(pqxx::transaction_base& txn);

    TaskFeed loadTasks(const TaskFeedParams& params, const TaskFilter& filter) const;

    Tasks loadAllActiveEditTasks() const;
    TIds  getAllActiveEditTasksCommitIds() const;

    TIds getTaskIds(const TaskFilter& filter) const;
    TIds getTaskIdsResolvedAt(DateTimeCondition resolvedAt) const;
    TIds getTaskIdsClosedAt(DateTimeCondition closedAt) const;

    Tasks loadTasksByTaskIds(const TaskIds& taskIds) const;
    Tasks loadActiveTasksByTaskIds(const TaskIds& taskIds) const;

    Tasks loadEditTasksByCommitIds(const TIds& commiIds) const;
    Tasks loadActiveEditTasksByCommitIds(const TIds& commiIds) const;


    Feed feed(
        TId branchId,
        TId subscriberId,
        FeedType feedType) const;

    Feed feed(
        TId branchId,
        TId subscriberId,
        FeedType feedType,
        FeedFilter filter) const;

    RegionFeedPtr regionFeed(
        TId branchId,
        std::string geometryMercatorWkb) const;

    Feed suspiciousFeed(TId branchId, FeedFilter filter) const;

    void removeOldSuspiciousUsers(chrono::Days olderThan = chrono::Days(14)) const;

    SubscriptionConsole subscriptionConsole(TUid uid) const;
    ModerationConsole moderationConsole(TUid uid) const;
    SuperModerationConsole superModerationConsole(TUid uid) const;
    TaskStatsConsole taskStatsConsole(ModerationMode mode) const;

    Event createCommitEvent(
        TUid uid,
        const CommitData& commitData,
        const std::optional<PrimaryObjectData>& primaryObjectData,
        const TIds& aoiIds) const;

    Event createCommitEvent(
        TUid uid,
        const CommitData& commitData,
        const std::optional<PrimaryObjectData>& primaryObjectData,
        const TIds& aoiIds,
        const std::optional<EventExtraData>& extraData) const;

    Event createCloseFeedbackEvent(
        TUid uid,
        const feedback::Task& feedbackTask,
        const TIds& aoiIds) const;

    Events loadEditEventsByCommitIds(const TIds& commitIds) const;
    Events loadTrunkEditEventsByCommitIds(const TIds& commitIds) const;
    Events loadTrunkEditEventsByCommitIdsCreatedBefore(const TIds& commitIds, chrono::TimePoint createdBefore) const;

    Events loadEditEventsByCommitRange(TId from, TId to) const;
    Events loadTrunkEditEventsByCommitRange(TId from, TId to) const;

    Events loadEditEventsWithExtraDataByCommitIds(const TIds& commitIds) const;

    Events loadEditEventsByCreationInterval(const DateTimeCondition& createdAt) const;
    Events loadNoTaskEditsByCreationInterval(const DateTimeCondition& createdAt) const;
    Events loadEventsByIds(const TIds& eventIds) const;

    // @warning Robots left no information about created commits in the `social`
    //   schema. Therefore, this method should always return std::nullopt for
    //   such users.
    std::optional<TId> getRecentEditCommitMadeBy(TUid userId, const TIds& commitIds) const;

    Task createTask(const Event& event, const std::string& userCreatedOrUnbannedAt) const;
    Task createAcceptedTask(const Event& event, const std::string& userCreatedOrUnbannedAt) const;

    Comment createComment(
        TUid uid, CommentType type, const std::string& data,
        TId commitId, TId objectId, std::optional<TId> feedbackTaskId,
        const TIds& aoiIds, Comment::Internal internal = Comment::Internal::No) const;

    CommentsFeed commentsFeed(const CommentsFeedParams& params) const;

    Comments loadComments(const TIds& commentIds) const;

    Comments clearUserComments(
        TUid createdBy,
        TUid deletedBy) const;

    void saveEventAlerts(const EventAlerts& alerts) const;

    // result is sorted by (eventId, priority)
    EventAlerts loadEventAlerts(const TIds& eventIds) const;

    UserActivity getUserActivity(
        TUid uid,
        const std::vector<std::chrono::seconds>& timeIntervals,
        ActivityType type) const;

    /// @return A list of users (their identities) whos actions lead to creation
    /// of moderation tasks during the provided time interval.
    std::vector<TUid> getActiveUserIds(
        chrono::TimePoint activityTimeBegin,
        chrono::TimePoint activityTimeEnd);

    /// Recalculate 'skills' for the users with provided identities.
    void updateSkills(const std::vector<TUid>& uids);

    SkillsByUid getSkills(const std::vector<TUid>& uids);

    TIds getAoiIdsOfActiveEditTask(TId commitId);

    std::optional<UserData> getUserData(TUid uid) const;
    UserData setUserData(TUid uid, const std::string& data) const;

    void saveUserActivity(
        TUid uid,
        const std::string& ip,
        std::optional<uint16_t> port,
        UserActivityAction action,
        const std::optional<TId>& entityId) const;

    void saveUserActivityAlert(TUid uid, const std::string& reason) const;

private:
    pqxx::transaction_base& txn_;
};

} // namespace maps::wiki::social
