#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/event.h>

#include <list>
#include <vector>
#include <utility>

namespace maps::wiki::social {

using Events = std::list<Event>;

/**
 * 
 * Interface class for events feeds.
 * 
 * Events order.
 * At the moment the feed events are always sorted 
 * by event id in descending order.
 * 
 * For example.
 * One has events in database with following ids:
 * ids = [{id=1}, {id=2}, {id=3}, {id=4}, {id=5}]
 * 
 * eventsHead(limit=2) returns:
 * pair<Events[{id=5}, {id=4}], HasMore::Yes>
 *  
 * eventsAfter(eventId=2, limit=2) returns:
 * pair<Events[{id=4}, {id=3}], HasMore::Yes>
 * 
 * eventsBefore(eventId=3, limit=2) returns:
 * pair<Events[{id=2}, {id=1}], HasMore::No>
 * 
 * TODO: change this behaviour according to the task:
 * https://st.yandex-team.ru/NMAPS-11141
 * 
 **/
class IFeed {
public:
    virtual ~IFeed() = default;

    virtual void setCategoryIdsFilter(CategoryIdsFilter categoryIdsFilter) = 0;
    virtual const CategoryIdsFilter& categoryIdsFilter() const = 0;

    virtual size_t count() const = 0;

    virtual Events events(size_t offset, size_t limit) const = 0;

    virtual std::pair<Events, HasMore> eventsHead(size_t limit) const = 0;
    virtual std::pair<Events, HasMore> eventsAfter(TId eventId, size_t limit) const = 0;
    virtual std::pair<Events, HasMore> eventsBefore(TId eventId, size_t limit) const = 0;
};

using IFeedPtr = std::unique_ptr<IFeed>;

} // namespace maps::wiki::social
