#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/geolib/include/bounding_box.h>

#include <optional>
#include <string>

namespace maps::wiki::social {

enum class Enabled
{
    Yes,
    No
};

enum class Active
{
    Yes,
    No
};

class InvolvementFilter
{
public:
    InvolvementFilter() = default;

    InvolvementFilter& enabled(Enabled enabled);
    InvolvementFilter& startedBefore(chrono::TimePoint startTime);
    InvolvementFilter& startedAfter(chrono::TimePoint startTime);
    InvolvementFilter& finishedBefore(chrono::TimePoint finishTime);
    InvolvementFilter& finishedAfter(chrono::TimePoint finishTime);
    InvolvementFilter& boundedBy(const geolib3::BoundingBox& bboxMerc);

    //active(Yes) means enabled(Yes) && startedBefore(now) && finishedAfter(now)
    InvolvementFilter& active(Active active);

private:
    friend class Involvement;

    std::optional<Enabled> enabled_;
    std::optional<Active> active_;
    std::optional<chrono::TimePoint> startedBefore_;
    std::optional<chrono::TimePoint> startedAfter_;
    std::optional<chrono::TimePoint> finishedBefore_;
    std::optional<chrono::TimePoint> finishedAfter_;
    std::optional<geolib3::BoundingBox> bboxMerc_;
};

} //namespace maps::wiki::social
