#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/involvement.h>
#include <maps/libs/introspection/include/comparison.h>

#include <pqxx/pqxx>

#include <cstddef>
#include <map>
#include <string>
#include <vector>

namespace maps::wiki::social {

class InvolvementStat;
typedef std::vector<InvolvementStat> InvolvementStats;

class InvolvementStat
{
public:
    /*
     * Creates new counter with zero value
     */
    InvolvementStat() = default;
    InvolvementStat(
        TId involvementId,
        std::string type
    );

    bool operator<(const InvolvementStat& toCompare) const;
    bool operator==(const InvolvementStat& toCompare) const;

    TId involvementId() const;
    const std::string& type() const;

    int64_t value() const;

    InvolvementStat& operator+= (int64_t value);
    InvolvementStat& operator-= (int64_t value)
    {
        return (*this += (-value));
    }

    static InvolvementStats byInvolvementId(
        pqxx::transaction_base& socialTxn,
        TId involvementId
    );
    static InvolvementStats byInvolvements(
        pqxx::transaction_base& socialTxn,
        const Involvements& involvements
    );

    void writeToDatabase(pqxx::transaction_base& socialTxn);

    auto introspect() const
    {
        return std::tie(involvementId_, type_, value_, valueAddition_, state_);
    }

private:
    /**
     * Due to lazy creation of involvement stats,
     * special state is required to indicate if this stat should be
     * inserted or updated
     */
    enum class State
    {
        New,
        Existent
    };
    InvolvementStat(const pqxx::row& row);

    TId involvementId_{};
    std::string type_;
    int64_t value_{};
    int64_t valueAddition_{};
    State state_;
};
using introspection::operator<;
using introspection::operator==;

using InvolvementStatMap = std::map<Involvement, InvolvementStats>;
//loads corresponding InvolvementStats from database,
//inserts zero-valued counters in InvolvementStat
//for the corresponding category wasn't found
InvolvementStatMap loadInvolvementStatMap(
    pqxx::transaction_base& socialTxn,
    const Involvements& involvements
);

} //namespace maps::wiki::social
