#pragma once

#include <yandex/maps/wiki/social/common.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <map>

namespace maps::wiki::social {

enum class ModerationMode { Moderator, SuperModerator, Supervisor };

enum class ResolveResolution { Accept, Edit, Revert };
DECLARE_ENUM_IO(ResolveResolution);

enum class CloseResolution { Approve, Edit, Revert };
DECLARE_ENUM_IO(CloseResolution);

class TaskCounts
{
public:
    TaskCounts() = default;
    TaskCounts(size_t available, size_t acquired, size_t old, size_t total);
    TaskCounts& operator+=(const TaskCounts& other);

    size_t available() const { return available_; }
    size_t acquired() const { return acquired_; }
    size_t old() const { return old_; }
    size_t total() const { return total_; }

private:
    size_t available_ = 0;
    size_t acquired_ = 0;
    size_t old_ = 0;
    size_t total_ = 0;
};

TaskCounts operator+ (const TaskCounts& lhs, const TaskCounts& rhs);
bool operator== (const TaskCounts& lhs, const TaskCounts& rhs);


using CountsByCategoryId = std::map<std::string, TaskCounts>;

struct CountsByAoiCategoryId
{
    std::map<TId, CountsByCategoryId> taskCounts;
    size_t oldTaskAgeInHours;
};

} // namespace maps::wiki::social
