#pragma once

#include <yandex/maps/wiki/social/event_filter.h>
#include <yandex/maps/wiki/social/moderation_time_intervals.h>
#include <yandex/maps/wiki/social/task.h>

#include <optional>

namespace maps::wiki::social {

class Factory;

class ModerationConsole
{
public:
    Tasks acquireTasks(
        const EventFilter& eventFilter,
        std::optional<size_t> limit,
        TasksOrder tasksOrder,
        const ModerationTimeIntervals& moderationTimeIntervals) const;
    TaskIds releaseTasks() const;

private:
    friend class Factory;
    ModerationConsole(
        pqxx::transaction_base& work,
        TUid uid);

    pqxx::transaction_base& work_;
    const TUid uid_;
};

} // namespace maps::wiki::social
