#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <maps/libs/chrono/include/time_point.h>

#include <pqxx/pqxx>

#include <optional>
#include <vector>

namespace maps::wiki::social {

class Profile
{
public:
    Profile() = default;

    explicit Profile(const pqxx::row& row);

    Profile(
        TUid uid,
        std::string about,
        std::string email,
        bool broadcastSubscription,
        bool newsSubscription,
        bool newsSubscriptionWelcomeMailSent,
        std::optional<chrono::TimePoint> newsSubscriptionModifiedAt,
        std::string locale
    );

    TUid uid() const { return uid_; }
    const std::string& about() const { return about_; }
    const std::string& email() const { return email_; }
    bool hasBroadcastSubscription() const { return broadcastSubscription_; }
    const std::string& locale() const { return locale_; }

    bool hasNewsSubscription() const { return newsSubscription_; }

    bool isNewsSubscriptionWelcomeMailSent() const {
        return newsSubscriptionWelcomeMailSent_;
    }

    const std::optional<chrono::TimePoint>&
    newsSubscriptionModifiedAt() const {
        return newsSubscriptionModifiedAt_;
    }

private:
    TId uid_;
    std::string about_;
    std::string email_;
    bool broadcastSubscription_;

    bool newsSubscription_;
    bool newsSubscriptionWelcomeMailSent_;
    std::optional<chrono::TimePoint> newsSubscriptionModifiedAt_;

    std::string locale_;
};

using Profiles = std::vector<Profile>;


struct ProfileOptionalFields
{
    bool empty() const;

    std::optional<std::string> about;
    std::optional<std::string> email;
    std::optional<bool> hasBroadcastSubscription;
    std::optional<bool> hasNewsSubscription;
    std::optional<bool> newsSubscriptionWelcomeMailSent;
    std::optional<std::string> locale;
};

} // namespace maps::wiki::social
