#pragma once

#include <yandex/maps/wiki/social/profile.h>

#include <optional>
#include <pqxx/pqxx>

namespace maps::wiki::social {


class IProfileGateway
{
public:
    virtual std::optional<Profile> getUserProfile(TUid uid) const = 0;
    virtual Profiles getUserProfiles(const TUids& uids) const = 0;
    virtual Profiles getAllUserProfiles() const = 0;

    // updates only specified fields
    // at least one field to update should be specified
    // returns updated profile if uid exists and std::nullopt otherwise
    //
    virtual std::optional<Profile> updateProfile(const TUid& uid, const ProfileOptionalFields& optionalFields) = 0;

    // insert only specified fields
    // throws exception in case of primary key conflict
    //
    virtual Profile insertProfile(const TUid& uid, const ProfileOptionalFields& optionalFields) = 0;

    // works like insert on conflict update
    //
    virtual Profile upsertProfile(const TUid& uid, const ProfileOptionalFields& optionalFields) = 0;

    virtual ~IProfileGateway() = default;
};


class ProfileGateway : public IProfileGateway
{
public:
    explicit ProfileGateway(pqxx::transaction_base& txn);

    std::optional<Profile> getUserProfile(TUid uid) const override;
    Profiles getUserProfiles(const TUids& uids) const override;
    Profiles getAllUserProfiles() const override;

    std::optional<Profile> updateProfile(
        const TUid& uid,
        const ProfileOptionalFields& optionalFields) override;

    Profile insertProfile(
        const TUid& uid,
        const ProfileOptionalFields& optionalFields) override;

    Profile upsertProfile(
        const TUid& uid,
        const ProfileOptionalFields& optionalFields) override;

private:
    pqxx::transaction_base& txn_;
};

} // namespace maps::wiki::social
