#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace maps::wiki::social {

enum class PromptType
{
    NewsSubscription
};

DECLARE_ENUM_IO(PromptType);


struct Prompt
{
    Prompt() = default;
    Prompt(TId id, TUid uid, PromptType type, chrono::TimePoint processedAt);

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(t.id, t.uid, t.type, t.processedAt);
    }

    TId id{};
    TUid uid{};
    PromptType type{};
    chrono::TimePoint processedAt{chrono::TimePoint::clock::now()};
};

using Prompts = std::vector<Prompt>;

} // namespace maps::wiki::social
