#pragma once

#include "prompt.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::wiki::social {

namespace table {
using namespace sql_chemistry;

struct PromptTbl : Table<Prompt>
{
    static constexpr std::string_view name_{"social.prompt"};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr Int64Column uid{"uid"sv, name_};
    static constexpr EnumColumn<PromptType> type{"type"sv, name_};
    static constexpr TimePointColumn processedAt{"processed_at"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, uid, type, processedAt);
    }
};

} // namespace table

using PromptGateway = sql_chemistry::Gateway<table::PromptTbl>;

} // namespace maps::wiki::social
