#pragma once

#include "common.h"

#include <pqxx/pqxx>

namespace maps::wiki::social {

namespace commits_handlers {

const std::string RELEASES_NOTIFICATION = "releases_notification_worker";
const std::string NOTIFICATIONS_DISPATCHER = "notifications_dispatcher";

}

class PublishedCommits
{
public:
    explicit PublishedCommits(pqxx::transaction_base& txn)
        : txn_(txn)
    {}

    void push(const TIds& commitIds);

    /// Selects (FOR UPDATE) all pending ids to process() later
    TIds getUnprocessedIds(const std::string& handler);
    void process(const TIds& commitIds, const std::string& handler);

protected:
    void push(const TIds& commitIds, const std::set<std::string>& handlers);

private:
    template <typename Container>
    std::string containerValues(const Container& data) const;

    pqxx::transaction_base& txn_;
};

}  // maps::wiki::social
