#pragma once

#include <maps/libs/xml/include/xml.h>
#include <yandex/maps/wiki/social/rate_limiter_config_loader.h>
#include <yandex/maps/wiki/social/gateway.h>
#include <optional>
#include <string>

namespace maps::wiki::social {

class RateLimiter
{
public:
    explicit RateLimiter(const maps::xml3::Node& node);

    std::optional<std::chrono::seconds> checkLimitExceeded(
        Gateway& gateway,
        TUid uid,
        ActivityType type) const;

private:
    using Limits = RateLimiterConfigLoader::Limits;

    const Limits& getLimits(social::ActivityType type) const;

    Limits commentLimits_;
    Limits editLimits_;
    Limits feedbackResolveLimits_;
};

} // namespace maps::wiki::social

