#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <maps/libs/xml/include/xml.h>
#include <chrono>
#include <string>
#include <vector>

namespace maps::wiki::social {

class RateLimiterConfigLoader
{
public:
    explicit RateLimiterConfigLoader(const maps::xml3::Node& node);

    struct Limits {
        UserActivity acceptableActivity;
        std::vector<std::chrono::seconds> timeIntervals;
    };

    Limits loadLimits(const std::string& section) const;

private:
    const maps::xml3::Node& node_;
};

std::optional<std::chrono::seconds> findLimitExceeded(
    const RateLimiterConfigLoader::Limits& limits,
    const UserActivity& activity);

} // namespace maps::wiki::social

