#pragma once
#include <yandex/maps/wiki/social/i_feed.h>

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/feed_filter.h>

#include <maps/libs/common/include/exception.h>

#include <optional>
#include <pqxx/pqxx>
#include <string>
#include <utility>

namespace maps::wiki::social {

enum class EventBoundsPredicate { CoveredByRegion, IntersectsRegion };

class RegionFeed : public IFeed {
public:
    RegionFeed(
        pqxx::transaction_base& work,
        TId branchId,
        std::string regionGeometryMercatorWkb,
        EventBoundsPredicate boundsPredicate =
            EventBoundsPredicate::CoveredByRegion)
        : work_(work)
        , branchId_(branchId)
        , boundsPredicate_(boundsPredicate)
        , regionGeometryMercatorWkb_(std::move(regionGeometryMercatorWkb))
    {}

    void setCategoryIdsFilter(CategoryIdsFilter categoryIdsFilter) override { categoryIdsFilter_ = std::move(categoryIdsFilter); }
    const CategoryIdsFilter& categoryIdsFilter() const override { return categoryIdsFilter_; }

    void setSkippedUids(TUids skippedUids) { skippedUids_ = std::move(skippedUids); }
    const TUids& skippedUids() const { return skippedUids_; }

    size_t count() const override { ASSERT(false); return {}; }
    Events events(size_t /*offset*/, size_t /*limit*/) const override { ASSERT(false); return {}; }

    std::pair<Events, HasMore> eventsHead(size_t limit)                const override;
    std::pair<Events, HasMore> eventsAfter(TId eventId, size_t limit)  const override;
    std::pair<Events, HasMore> eventsBefore(TId eventId, size_t limit) const override;

private:
    std::string whereClause() const;

    pqxx::transaction_base& work_;

    TId branchId_;
    EventBoundsPredicate boundsPredicate_;
    std::string regionGeometryMercatorWkb_;
    CategoryIdsFilter categoryIdsFilter_{{}, InclusionPolicy::Excluding}; // Exclude nothing by default.
    TUids skippedUids_;
};

using RegionFeedPtr = std::unique_ptr<RegionFeed>;

} // namespace maps::wiki::social
