#pragma once

#include <yandex/maps/wiki/social/common.h>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/json/include/value.h>


namespace maps::wiki::social {

enum class NotificationChannel
{
    Email,
    Bell,
    Messenger,
};

DECLARE_ENUM_IO(NotificationChannel);


enum class NotificationType
{
    WelcomeToService,
    YourEditsArePublished,
    AchievementEditsCount,
    AddressesShowsCount
};

DECLARE_ENUM_IO(NotificationType);


struct SentNotification
{
    SentNotification() = default;

    SentNotification(
        TId id, TUid uid, NotificationChannel channel,
        NotificationType type, json::Value args, chrono::TimePoint sentAt
    );

    template <typename T>
    static auto introspect(T& t) {
        return std::tie(
            t.id, t.uid, t.channel, t.type, t.args, t.sentAt
        );
    }

    TId id{};
    TUid uid{};
    NotificationChannel channel{};
    NotificationType type{};
    json::Value args{json::repr::ObjectRepr{}};
    chrono::TimePoint sentAt{chrono::TimePoint::clock::now()};
};

} // namespace maps::wiki::social
