#pragma once

#include "sent_notification.h"

#include <maps/libs/sql_chemistry/include/gateway.h>

namespace maps::wiki::social {

namespace table {
using namespace sql_chemistry;

struct SentNotificationTbl : Table<SentNotification>
{
    static constexpr std::string_view name_{"social.sent_notifications"};

    static constexpr BigSerialKey id{"id"sv, name_};
    static constexpr Int64Column uid{"uid"sv, name_};
    static constexpr EnumColumn<NotificationChannel> channel{"channel"sv, name_};
    static constexpr EnumColumn<NotificationType> type{"type"sv, name_};
    static constexpr JsonColumn args{"args"sv, name_};
    static constexpr TimePointColumn sentAt{"sent_at"sv, name_};

    static constexpr auto columns_() {
        return std::tie(id, uid, channel, type, args, sentAt);
    }
};

} // namespace table

using SentNotificationGateway = sql_chemistry::Gateway<table::SentNotificationTbl>;

} // namespace maps::wiki::social
