#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/exception.h>

#include <pqxx/pqxx>

#include <memory>
#include <list>

namespace maps::wiki::social {

class Subscription
{
public:
    TUid subscriber() const { return subscriber_; }
    TId feedId() const { return feedId_; }

private:
    friend class Factory;
    explicit Subscription(const pqxx::row& row);

    const TUid subscriber_;
    const TId feedId_;
};

using Subscriptions = std::list<Subscription>;

class SubscriptionConsole
{
public:
    Subscription subscribe(TId feedId) const;
    void dropSubscription(TId feedId) const;

    Subscriptions subscriptions() const;

private:
    friend class Factory;
    SubscriptionConsole(
        pqxx::transaction_base& work,
        TUid subscriber);

    pqxx::transaction_base& work_;
    const TUid subscriber_;
};

} // namespace maps::wiki::social
