#pragma once

#include <yandex/maps/wiki/social/event_filter.h>
#include <yandex/maps/wiki/social/moderation_time_intervals.h>
#include <yandex/maps/wiki/social/task.h>

namespace maps::wiki::social {

class SuperModerationConsole
{
public:
    CountsByAoiCategoryId countsByAoiCategoryId(
        ModerationMode mode,
        const EventFilter& eventFilter,
        const TIds& aoiIds,
        const ModerationTimeIntervals& moderationTimeIntervals) const;

    // available() > 0 or acquired() > 0
    bool hasAcquirableTasks(
        ModerationMode mode,
        const TIds& aoiIds,
        const ModerationTimeIntervals& moderationTimeIntervals) const;

    // for non-resolved tasks only
    TaskIds resolveTasksByTaskIds(
        ResolveResolution resolution, const TaskIds& taskIds) const;

    TaskIds resolveEditTasksByCommitIds(
        ResolveResolution resolution, const TIds& commitIds) const;

    // skip non-resolved tasks
    TaskIds closeTasksByTaskIds(
        CloseResolution resolution, const TaskIds& taskIds) const;

    // set custom resolveResolution for non-resolved tasks
    TaskIds closeTasksByTaskIds(
        const TIds& taskIds,
        ResolveResolution resolveRresolution,
        CloseResolution closeResolution) const;

    // set custom resolveResolution for non-resolved tasks
    TaskIds closeEditTasksByCommitIds(
        const TIds& commitIds,
        ResolveResolution resolveResolution,
        CloseResolution closeResolution) const;

    // closes reverted tasks only
    TaskIds closeRevertedTasks(
        const Tasks& tasks,
        CloseResolution closeResolution) const;

    TaskIds resolveTasksByUserAndCloseByRobot(
        const TaskIds& taskIds,
        ResolveResolution resolveResolution,
        CloseResolution closeResolution) const;

    TaskIds resolveTasksByRobotAndCloseByUser(
        const TaskIds& taskIds,
        ResolveResolution resolveResolution,
        CloseResolution closeResolution) const;

    TaskIds deferTasksByTaskIds(
        const TaskIds& taskIds,
        const std::string& expiresAt) const;

    size_t todayProcessedCount(int tzInMinutes) const;

private:
    friend class Factory;
    SuperModerationConsole(
        pqxx::transaction_base& work,
        TUid uid);

    pqxx::transaction_base& work_;
    const TUid uid_;
};

} // namespace maps::wiki::social
