#pragma once

#include <yandex/maps/wiki/social/task.h>
#include <pqxx/pqxx>

namespace maps::wiki::social {

class TaskFeedParams
{
public:
    enum class OrderBy {
        ResolvedAt,
        ClosedAt
    };

    static constexpr size_t perPageDefault = 10;

    TaskFeedParams(TId before, TId after, size_t perPage, OrderBy orderBy)
        : before_(before)
        , after_(after)
        , perPage_(perPage)
        , orderBy_(orderBy)
    {}

    TId before() const { return before_; }
    TId after() const { return after_; }
    size_t perPage() const { return perPage_; }
    OrderBy orderBy() const { return orderBy_; }

private:
    TId before_;
    TId after_;
    size_t perPage_;
    OrderBy orderBy_;
};

class TaskFeed
{
public:
    TaskFeed(const Tasks& tasks, HasMore hasMore)
        : tasks_(tasks)
        , hasMore_(hasMore)
    {}

    const Tasks& tasks() const { return tasks_; }
    HasMore hasMore() const { return hasMore_; }

private:
    Tasks tasks_;
    HasMore hasMore_;
};

} // namespace maps::wiki::social
