#pragma once

#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/social/date_time_condition.h>
#include <yandex/maps/wiki/social/common.h>

#include <optional>

namespace maps::wiki::social {

class TaskFilter {
public:
    void setCategories(std::optional<CategoryIdsSet> value) { categories_ = value; }
    void setResolvedBy(TUids values) { resolvedBy_ = std::move(values); }
    void setResolvedAt(std::optional<DateTimeCondition> condition) { resolvedAt_ = condition; }
    void setResolveResolution(std::optional<ResolveResolution> value) { resolveResolution_ = value; }
    void setClosedBy(TUids values) { closedBy_ = std::move(values); }
    void setClosedAt(std::optional<DateTimeCondition> condition) { closedAt_ = condition; }
    void setCloseResolution(std::optional<CloseResolution> value) { closeResolution_ = value; }

    const auto& categories() const { return categories_; }
    const auto& resolvedBy() const { return resolvedBy_; }
    const auto& resolvedAt() const { return resolvedAt_; }
    const auto& resolveResolution() const { return resolveResolution_; }
    const auto& closedBy() const { return closedBy_; }
    const auto& closedAt() const { return closedAt_; }
    const auto& closeResolution() const { return closeResolution_; }

    std::string whereClause(pqxx::transaction_base& txn, const std::string& taskTableAlias) const;

private:
    std::optional<CategoryIdsSet> categories_;
    TUids resolvedBy_;
    std::optional<DateTimeCondition> resolvedAt_;
    std::optional<ResolveResolution> resolveResolution_;
    TUids closedBy_;
    std::optional<DateTimeCondition> closedAt_;
    std::optional<CloseResolution> closeResolution_;
};

} // namespace maps::wiki::social
