#pragma once

#include <yandex/maps/wiki/social/common.h>
#include <yandex/maps/wiki/social/moderation.h>
#include <yandex/maps/wiki/social/moderation_time_intervals.h>

#include <pqxx/pqxx>

#include <map>
#include <memory>
#include <optional>
#include <string>

namespace maps::wiki::social {

struct ActiveTaskStat
{
    size_t count;
    std::string oldestTaskActiveSince;
};

class TaskStatsConsole
{
public:
    // Removes all categories but predefined ones from the result
    // statistics.
    TaskStatsConsole& setFilterByCategories(CategoryIdsSet categoryIds);

    // Removes all events but `eventType` from the result statistics.
    TaskStatsConsole& setFilterByEventType(EventType eventType);

    std::map<TId, ActiveTaskStat> activeTaskStatsByAoi(const ModerationTimeIntervals& moderationTimeIntervals) const;
    std::map<TId, size_t> recentNewTaskCountsByAoi(const ModerationTimeIntervals& moderationTimeIntervals) const;
    std::map<TId, size_t> recentProcessedTaskCountsByAoi(const ModerationTimeIntervals& moderationTimeIntervals) const;

private:
    friend class Factory;
    TaskStatsConsole(
        pqxx::transaction_base& work,
        ModerationMode mode);

    pqxx::transaction_base& work_;
    ModerationMode mode_;
    std::optional<CategoryIdsSet> categoryIds_;
    std::optional<EventType> eventType_;
};

} // namespace maps::wiki::social
