#pragma once

#include <yandex/maps/wiki/social/common.h>

#include <maps/libs/chrono/include/time_point.h>
#include <pqxx/pqxx>
#include <string>

namespace maps::wiki::social {

class UserData
{
public:
    explicit UserData(const pqxx::row& row);

    TUid uid() const { return uid_; }
    const chrono::TimePoint& createdAt() const { return createdAt_; }
    const chrono::TimePoint& modifiedAt() const { return modifiedAt_; }
    const std::string& data() const { return data_; }

private:
    TUid uid_;
    chrono::TimePoint createdAt_;
    chrono::TimePoint modifiedAt_;
    std::string data_;
};

} // maps::wiki::social
