#include <yandex/maps/wiki/social/involvement_filter.h>

#include <string>

namespace maps::wiki::social {

InvolvementFilter&
InvolvementFilter::enabled(Enabled enabled)
{
    enabled_ = enabled;
    return *this;
}

InvolvementFilter&
InvolvementFilter::active(Active active)
{
    active_ = active;
    return *this;
}

InvolvementFilter&
InvolvementFilter::startedBefore(chrono::TimePoint startTime)
{
    startedBefore_ = startTime;
    return *this;
}

InvolvementFilter&
InvolvementFilter::startedAfter(chrono::TimePoint startTime)
{
    startedAfter_ = startTime;
    return *this;
}

InvolvementFilter&
InvolvementFilter::finishedBefore(chrono::TimePoint finishTime)
{
    finishedBefore_ = finishTime;
    return *this;
}

InvolvementFilter&
InvolvementFilter::finishedAfter(chrono::TimePoint finishTime)
{
    finishedAfter_ = finishTime;
    return *this;
}

InvolvementFilter&
InvolvementFilter::boundedBy(const geolib3::BoundingBox& bboxMerc)
{
    bboxMerc_ = bboxMerc;
    return *this;
}

} //namespace maps::wiki::social
