#pragma once

#include <string>

namespace maps::wiki::social {

namespace sql {

namespace schema {

const std::string SOCIAL = "social";

} // namespace schema

namespace table {

const std::string COMMENT = schema::SOCIAL + ".comment";
const std::string COMMIT_EVENT = schema::SOCIAL + ".commit_event";
const std::string FEEDBACK_EVENT = schema::SOCIAL + ".feedback_event";
const std::string AOI_COMMENT = schema::SOCIAL + ".aoi_comment";
const std::string AOI_FEED_STABLE = schema::SOCIAL + ".aoi_feed_stable";
const std::string AOI_FEED_TRUNK = schema::SOCIAL + ".aoi_feed_trunk";
const std::string AOI_FEED_TRUNK_WITHOUT_TASK = schema::SOCIAL + ".aoi_feed_trunk_without_task";
const std::string AOI_FEED_TRUNK_TASK = schema::SOCIAL + ".aoi_feed_trunk_task";
const std::string AOI_FEED_TRUNK_TASK_ACTIVE = schema::SOCIAL + ".aoi_feed_trunk_task_active";
const std::string TASK = schema::SOCIAL + ".task";
const std::string TASK_ACTIVE = schema::SOCIAL + ".task_active";
const std::string TASK_CLOSED = schema::SOCIAL + ".task_closed";
const std::string DEFERRED_TASK = schema::SOCIAL + ".deferred_task";

const std::string SUBSCRIPTION = schema::SOCIAL + ".subscription";
const std::string INVOLVEMENTS = schema::SOCIAL + ".involvements";
const std::string INVOLVEMENT_STATS = schema::SOCIAL + ".involvement_stats";

const std::string EVENT_ALERT = schema::SOCIAL + ".event_alert";
const std::string EVENT_EXTRA_DATA = schema::SOCIAL + ".event_extra_data";

const std::string PROFILE = schema::SOCIAL + ".profile";
const std::string PROMPT = schema::SOCIAL + ".prompt";

const std::string FEEDBACK_TASK = schema::SOCIAL + ".feedback_task";
const std::string FEEDBACK_TASK_PENDING = schema::SOCIAL + ".feedback_task_pending";
const std::string FEEDBACK_TASK_OUTGOING_OPENED = schema::SOCIAL + ".feedback_task_outgoing_opened";
const std::string FEEDBACK_TASK_OUTGOING_OPENED_EXPERIMENT = schema::SOCIAL + ".feedback_task_outgoing_opened_experiment";
const std::string FEEDBACK_TASK_OUTGOING_CLOSED = schema::SOCIAL + ".feedback_task_outgoing_closed";
const std::string FEEDBACK_AOI_FEED = schema::SOCIAL + ".feedback_aoi_feed";
const std::string FEEDBACK_AOI_FEED_PENDING = schema::SOCIAL + ".feedback_aoi_feed_pending";
const std::string FEEDBACK_AOI_FEED_OUTGOING_OPENED = schema::SOCIAL + ".feedback_aoi_feed_outgoing_opened";
const std::string FEEDBACK_AOI_FEED_OUTGOING_OPENED_EXPERIMENT = schema::SOCIAL + ".feedback_aoi_feed_outgoing_opened"; // not an error. we don't calc aois for experiments
const std::string FEEDBACK_AOI_FEED_OUTGOING_CLOSED = schema::SOCIAL + ".feedback_aoi_feed_outgoing_closed";
const std::string FEEDBACK_HISTORY = schema::SOCIAL + ".feedback_history";

const std::string FEEDBACK_PRESET = schema::SOCIAL + ".feedback_preset";

const std::string FEEDBACK_DISTINCT_SOURCE_TYPE_MV = "social.feedback_task_distinct_source_type_mv";
const std::string FEEDBACK_AOI_OLDEST_OPENED_TASK_MV = "social.feedback_aoi_oldest_opened_task_mv";
const std::string FEEDBACK_AOI_OLDEST_OPENED_TASK_DATA_MV = "social.feedback_aoi_oldest_opened_task_data_mv";
const std::string FEEDBACK_AOI_OPENED_TASK_STAT_MV = "social.feedback_aoi_opened_task_stat_mv";
const std::string FEEDBACK_AOI_OPENED_TASK_STAT_DATA_MV = "social.feedback_aoi_opened_task_stat_data_mv";

const std::string FBAPI_ISSUE = schema::SOCIAL + ".fbapi_issue";
const std::string COMMIT_FEEDBACK_TASK = schema::SOCIAL + ".commit_feedback_task";
const std::string EXTERNAL_REFERENCE_FEEDBACK_TASK = schema::SOCIAL + ".external_reference_feedback_task";

const std::string LAST_DEPLOYED_BRANCH = schema::SOCIAL + ".feedback_last_deployed_branch";
const std::string RESTRICTED_USERS = schema::SOCIAL + ".restricted_users";
const std::string SUSPICIOUS_USERS = schema::SOCIAL + ".suspicious_users";
const std::string SKILLS = schema::SOCIAL + ".skills";
const std::string STATS = schema::SOCIAL + ".stats";
const std::string USERDATA = schema::SOCIAL + ".userdata";
const std::string USER_ACTIVITY = schema::SOCIAL + ".user_activity";
const std::string USER_ACTIVITY_ALERTS = schema::SOCIAL + ".user_activity_alerts";

const std::string PUBLISHED_COMMITS = schema::SOCIAL + ".published_commits";

} // namespace table

namespace col {

const std::string CREATED_BY = "created_by";
const std::string CREATED_AT = "created_at";
const std::string MIN_CREATED_AT = "min_created_at";
const std::string MAX_CREATED_AT = "max_created_at";

const std::string BRANCH_ID = "branch_id";
const std::string COMMIT_ID = "commit_id";
const std::string ACTION = "action";
const std::string BOUNDS = "bounds";
const std::string BOUNDS_GEOM = "bounds_geom";

const std::string PRIMARY_OBJECT_ATTRS = "primary_object_attrs";
const std::string PRIMARY_OBJECT_CATEGORY_ID = "primary_object_category_id";
const std::string PRIMARY_OBJECT_ID = "primary_object_id";
const std::string PRIMARY_OBJECT_LABEL = "primary_object_label";
const std::string PRIMARY_OBJECT_NOTES = "primary_object_notes";

const std::string EVENT_ID = "event_id";
const std::string FT_TYPE_ID = "ft_type_id";
const std::string BUSINESS_RUBRIC_ID = "business_rubric_id";

const std::string AOI_ID = "aoi_id";
const std::string COMMENT_ID = "comment_id";

const std::string RESOLVED = "resolved";
const std::string RESOLVED_BY = "resolved_by";
const std::string RESOLVED_AT = "resolved_at";
const std::string RESOLVE_RESOLUTION = "resolve_resolution";
const std::string REJECT_REASON = "reject_reason";
const std::string CLOSED = "closed";
const std::string STATUS = "status";
const std::string CLOSED_BY = "closed_by";
const std::string CLOSED_AT = "closed_at";
const std::string CLOSE_RESOLUTION = "close_resolution";
const std::string LOCKED_BY = "locked_by";
const std::string LOCKED_AT = "locked_at";
const std::string HIDDEN = "hidden";
const std::string PROCESSING_LEVEL = "processing_level";  // legacy processing level of type int
const std::string PROCESSING_LVL = "processing_lvl";  // new processing level of enum type
const std::string INTERNAL_CONTENT = "internal_content";
const std::string INTERNAL = "internal";

const std::string ID = "id";
const std::string NAME = "name";
const std::string TYPE = "type";
const std::string TYPES = "types";
const std::string OBJECT_ID = "object_id";
const std::string DELETED_BY = "deleted_by";
const std::string DELETED_AT = "deleted_at";
const std::string DATA = "data";
const std::string HASH_VALUE = "hash_value";
const std::string SYNC_HASH_VALUE = "sync_hash_value";

const std::string SUBSCRIBER = "subscriber";
const std::string FEED_ID = "feed_id";
const std::string MODIFIED_AT = "modified_at";

const std::string TITLE = "title";
const std::string URL = "url";
const std::string ENABLED = "enabled";
const std::string START = "start";
const std::string FINISH = "finish";
const std::string POLYGON = "polygon";
const std::string POLYGONS = "polygons";

const std::string INVOLVEMENT_ID = "involvement_id";
const std::string VALUE = "value";

const std::string DEFERRED_BY = "deferred_by";
const std::string DEFERRED_AT = "deferred_at";
const std::string EXPIRES_AT = "expires_at";

const std::string PRIORITY = "priority";
const std::string DESCRIPTION = "description";

const std::string UID = "uid";
const std::string ABOUT = "about";
const std::string EMAIL = "email";
const std::string BROADCAST_SUBSCRIPTION = "broadcast_subscription";
const std::string NEWS_SUBSCRIPTION = "news_subscription";
const std::string NEWS_SUBSCRIPTION_MODIFIED_AT = "news_subscription_modified_at";
const std::string NEWS_SUBSCRIPTION_WELCOME_MAIL_SENT = "news_subscription_welcome_mail_sent";
const std::string LOCALE = "locale";

const std::string POSITION = "position";
const std::string INDOOR_LEVEL = "indoor_level";
const std::string ATTRS = "attrs";
const std::string RESOLUTION = "resolution";
const std::string ACQUIRED_BY = "acquired_by";
const std::string ACQUIRED_AT = "acquired_at";
const std::string DEPLOYED_AT = "deployed_at";
const std::string SOURCE = "source";
const std::string SOURCES = "sources";
const std::string WORKFLOWS = "workflows";
const std::string BUCKET = "bucket";
const std::string DUPLICATE_HEAD_ID = "duplicate_head_id";
const std::string VIEWED_BY = "viewed_by";
const std::string STATE_MODIFIED_AT = "state_modified_at";
const std::string AGE_TYPES = "age_types";

const std::string FEEDBACK_TASK_ID = "feedback_task_id";
const std::string ISSUE_ID = "issue_id";
const std::string RAW_DATA = "raw_data";

const std::string FIRST_COMMIT_AT = "first_commit_at";
const std::string REGISTERED_OR_UNBANNED_AT = "registered_or_unbanned_at";
const std::string CHANGES_0_30_SEC = "changes_0_30_sec";
const std::string AMOUNT = "amount";
const std::string IS_CREATED_BY_NOVICE = "is_created_by_novice";
const std::string CATEGORY_ID = "category_id";

const std::string REASON = "reason";

const std::string HANDLER = "handler";
const std::string PROCESSED = "processed";

const std::string IP_ADDR = "ip_addr";
const std::string PORT = "port";
const std::string ENTITY_ID = "entity_id";

const std::string FEEDBACK_HISTORY_ID = "feedback_history_id";
const std::string MODIFIED_BY = "modified_by";
const std::string OPERATION = "operation";
const std::string PARAMS = "params";

const std::string EXTERNAL_REFERENCE_ID = "external_reference_id";
const std::string READ_ROLE_ID = "read_role_id";
const std::string ALL_RIGHTS_ROLE_ID = "all_rights_role_id";

} // namespace col

namespace value {

const size_t MERCATOR_SRID = 3395;

const std::string TRUE = "TRUE";
const std::string FALSE = "FALSE";

const std::string NOW = "now()";

const std::string NULL_ = "NULL";

const std::string WORKFLOW_TASK = "task";
const std::string WORKFLOW_FEEDBACK = "feedback";

const std::string LOCK_DURATION = "'2 hours'::interval";

const std::string EVENT_TYPE_EDIT = "edit";

const std::string SUSPICIOUS_FIRST_COMMIT_INTERVAL = "'1 min'::interval";
const std::string SUSPICIOUS_CHANGES_0_30_SEC = "1";

const std::string RESOLVE_RESOLUTION_ACCEPT = "'accept'::social.resolve_resolution_type";

} // namespace value

namespace func {

const std::string ST_WITHIN = "st_within";
const std::string ST_GEOMFROMWKB = "st_geomfromwkb";
const std::string ST_ASBINARY = "st_asbinary";

} // namespace func

namespace pkey {
const std::string SKILLS = "skills_pkey";
} // namespace pkey

} // namespace sql

const std::string COMMENT_FIELDS_PREFIX = "comment_";
const std::string FEEDBACK_FIELDS_PREFIX = "feedback_";
const std::string FEEDBACK_SOURCE_EXPERIMENT_PREFIX = "experiment-";

} // namespace maps::wiki::social
