#include <yandex/maps/wiki/social/moderation.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::social {

TaskCounts::TaskCounts(
    size_t available,
    size_t acquired,
    size_t old,
    size_t total
)
    : available_(available)
    , acquired_(acquired)
    , old_(old)
    , total_(total)
{}

TaskCounts&
TaskCounts::operator+=(const TaskCounts& other)
{
    available_ += other.available_;
    acquired_  += other.acquired_;
    old_       += other.old_;
    total_     += other.total_;
    return *this;
}

TaskCounts operator+ (const TaskCounts& lhs, const TaskCounts& rhs)
{
    TaskCounts res = lhs;
    res += rhs;
    return res;
}

bool operator== (const TaskCounts& lhs, const TaskCounts& rhs)
{
    return lhs.available() == rhs.available() &&
           lhs.acquired() == rhs.acquired() &&
           lhs.old() == rhs.old() &&
           lhs.total() == rhs.total();
}

constexpr maps::enum_io::Representations<ResolveResolution> RESOLVE_RESOLUTION_REPRESENTATION {
    {ResolveResolution::Accept, "accept"},
    {ResolveResolution::Edit,   "edit"},
    {ResolveResolution::Revert, "revert"}
};
DEFINE_ENUM_IO(ResolveResolution, RESOLVE_RESOLUTION_REPRESENTATION);

constexpr maps::enum_io::Representations<CloseResolution> CLOSE_RESOLUTION_REPRESENTATION {
    {CloseResolution::Approve, "approve"},
    {CloseResolution::Edit,    "edit"},
    {CloseResolution::Revert,  "revert"}
};
DEFINE_ENUM_IO(CloseResolution, CLOSE_RESOLUTION_REPRESENTATION);

} // namespace maps::wiki::social
