#include <yandex/maps/wiki/social/moderation_console.h>
#include "tasks/acquire.h"
#include "tasks/release.h"
#include "tasks/count.h"
#include "helpers.h"

namespace maps::wiki::social {

ModerationConsole::ModerationConsole(
    pqxx::transaction_base& work,
    TUid uid
)
    : work_(work)
    , uid_(uid)
{
    checkUid(uid);
}

Tasks
ModerationConsole::acquireTasks(
    const EventFilter& eventFilter,
    std::optional<size_t> limit,
    TasksOrder taskOrder,
    const ModerationTimeIntervals& moderationTimeIntervals) const
{
    return tasks::acquire(work_, uid_, eventFilter, limit, taskOrder, moderationTimeIntervals);
}

TaskIds
ModerationConsole::releaseTasks() const
{
    return tasks::release(work_, uid_);
}

} // namespace maps::wiki::social
