#include <yandex/maps/wiki/social/profile.h>

#include "magic_strings.h"

namespace maps::wiki::social {

Profile::Profile(const pqxx::row& row)
    // c_str() is used (not as<std::string>) below because fields can be NULL.
    : uid_(row[sql::col::UID].as<TUid>())
    , about_(row[sql::col::ABOUT].c_str())
    , email_(row[sql::col::EMAIL].c_str())
    , broadcastSubscription_(row[sql::col::BROADCAST_SUBSCRIPTION].as<bool>())
    , newsSubscription_(row[sql::col::NEWS_SUBSCRIPTION].as<bool>())
    , newsSubscriptionWelcomeMailSent_(row[sql::col::NEWS_SUBSCRIPTION_WELCOME_MAIL_SENT].as<bool>())
    , locale_(row[sql::col::LOCALE].c_str())
{
    if (!row[sql::col::NEWS_SUBSCRIPTION_MODIFIED_AT].is_null()) {
        newsSubscriptionModifiedAt_ = chrono::parseSqlDateTime(
            row[sql::col::NEWS_SUBSCRIPTION_MODIFIED_AT].as<std::string>()
        );
    }
}

Profile::Profile(
    TUid uid,
    std::string about,
    std::string email,
    bool broadcastSubscription,
    bool newsSubscription,
    bool newsSubscriptionWelcomeMailSent,
    std::optional<chrono::TimePoint> newsSubscriptionModifiedAt,
    std::string locale)
        : uid_(uid)
        , about_(std::move(about))
        , email_(std::move(email))
        , broadcastSubscription_(broadcastSubscription)
        , newsSubscription_(newsSubscription)
        , newsSubscriptionWelcomeMailSent_(newsSubscriptionWelcomeMailSent)
        , newsSubscriptionModifiedAt_(std::move(newsSubscriptionModifiedAt))
        , locale_(std::move(locale))
{}

bool
ProfileOptionalFields::empty() const
{
    return !about &&
           !email &&
           !hasBroadcastSubscription &&
           !hasNewsSubscription &&
           !newsSubscriptionWelcomeMailSent &&
           !locale;
}

} // namespace maps::wiki::social
