#include <yandex/maps/wiki/social/prompt.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::social {

using namespace std::string_view_literals;

constexpr enum_io::Representations<PromptType> PROMPT_TYPE_STRINGS{
    {PromptType::NewsSubscription, "news-subscription"sv},
};

DEFINE_ENUM_IO(PromptType, PROMPT_TYPE_STRINGS);

Prompt::Prompt(
    TId id, TUid uid, PromptType type, chrono::TimePoint processedAt) :
        id(id), uid(uid), type(type), processedAt(processedAt)
{}

} // namespace maps::wiki::social
