#include <yandex/maps/wiki/social/rate_limiter.h>

namespace maps::wiki::social {

namespace {

const std::string COMMENTS = "comments";
const std::string EDITS = "edits";
const std::string FEEDBACK_RESOLVE = "feedback-resolve";

} // namespace

RateLimiter::RateLimiter(const maps::xml3::Node& node)
{
    if (node.isNull()) {
        return;
    }

    RateLimiterConfigLoader loader(node);

    commentLimits_ = loader.loadLimits(COMMENTS);
    editLimits_ = loader.loadLimits(EDITS);
    feedbackResolveLimits_ = loader.loadLimits(FEEDBACK_RESOLVE);
}

std::optional<std::chrono::seconds> RateLimiter::checkLimitExceeded(
    Gateway& gateway,
    TUid uid,
    ActivityType type) const
{
    const auto& limits = [&] {
        switch (type) {
            case ActivityType::Comments:
                return commentLimits_;
            case ActivityType::Edits:
                return editLimits_;
            case ActivityType::FeedbackResolve:
                return feedbackResolveLimits_;
        }
    }();

    auto activity = gateway.getUserActivity(uid, limits.timeIntervals, type);
    return findLimitExceeded(limits, activity);
}

} // namespace maps::wiki::social
