#include <yandex/maps/wiki/social/sent_notification.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::social {

using namespace std::string_view_literals;

constexpr enum_io::Representations<NotificationChannel> NOTIFICATION_CHANNEL_STRINGS{
    {NotificationChannel::Email, "email"sv},
    {NotificationChannel::Bell, "bell"sv},
    {NotificationChannel::Messenger, "messenger"sv}
};

DEFINE_ENUM_IO(NotificationChannel, NOTIFICATION_CHANNEL_STRINGS);

constexpr enum_io::Representations<NotificationType> NOTIFICATION_TYPE_STRINGS{
    {NotificationType::WelcomeToService, "welcome-to-service"sv},
    {NotificationType::YourEditsArePublished, "your-edits-are-published"sv},
    {NotificationType::AchievementEditsCount, "achievement-edits-count"sv},
    {NotificationType::AddressesShowsCount, "addresses-shows-count"sv},
};

DEFINE_ENUM_IO(NotificationType, NOTIFICATION_TYPE_STRINGS);

SentNotification::SentNotification(
    TId id, TUid uid, NotificationChannel channel,
    NotificationType type, json::Value args, chrono::TimePoint sentAt) :
        id(id), uid(uid), channel(channel), type(type),
        args(std::move(args)), sentAt(sentAt)
{}

} // namespace maps::wiki::social
