#include <yandex/maps/wiki/social/subscription_console.h>

#include "factory.h"
#include "helpers.h"
#include "magic_strings.h"

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::social {

Subscription::Subscription(const pqxx::row& row)
    : subscriber_(row[sql::col::SUBSCRIBER].as<TUid>())
    , feedId_(row[sql::col::FEED_ID].as<TId>())
{}

SubscriptionConsole::SubscriptionConsole(
    pqxx::transaction_base& work,
    TUid subscriber
)
    : work_(work)
    , subscriber_(subscriber)
{}

Subscription
SubscriptionConsole::subscribe(TId feedId) const
{
    std::stringstream insertQuery;
    insertQuery
        << "INSERT INTO " << sql::table::SUBSCRIPTION
        << "(" << sql::col::SUBSCRIBER << "," << sql::col::FEED_ID << ") VALUES ("
        << subscriber_ << "," << feedId
        << ") RETURNING *";
    try {
        auto result = work_.exec(insertQuery.str());
        ASSERT(result.size() == 1);
        return Factory::component<Subscription>(result[0]);
    } catch (const pqxx::unique_violation& ex) {
        throw DuplicateSubscription()
            << "duplicate subscription for uid: " << subscriber_
            << " feed id: " << feedId;
    }
}

void
SubscriptionConsole::dropSubscription(TId feedId) const
{
    std::stringstream query;
    query << "DELETE FROM " << sql::table::SUBSCRIPTION
          << " WHERE " << sql::col::SUBSCRIBER << "=" << subscriber_
          << " AND " << sql::col::FEED_ID << "=" << feedId;
    auto result = work_.exec(query.str());
    if (result.affected_rows() != 1) {
        throw SubscriptionNotFound()
            << "subscription id: " << feedId
            << " not found for subscriber uid: " << subscriber_;
    }
}

Subscriptions
SubscriptionConsole::subscriptions() const
{
    std::stringstream query;
    query << "SELECT * FROM " << sql::table::SUBSCRIPTION
          << " WHERE " << sql::col::SUBSCRIBER << "=" << subscriber_;
    auto queryResult = work_.exec(query.str());
    Subscriptions result;
    for (const auto& row : queryResult) {
        result.push_back(Factory::component<Subscription>(row));
    }
    return result;
}

} // namespace maps::wiki::social
