#include "tables_columns.h"
#include "magic_strings.h"

#include <yandex/maps/wiki/common/string_utils.h>

#include <algorithm>
#include <map>
#include <vector>
#include <stdexcept>
#include <functional>

using TransformFunc = std::function<std::string(const std::string&)>;

namespace maps::wiki::social {

namespace {

const std::vector<std::string> FEEDBACK_TASK_FIELDS {
    sql::col::ID,
    sql::col::CREATED_AT,
    sql::col::POSITION,
    sql::col::TYPE,
    sql::col::BUCKET,
    sql::col::SOURCE,
    sql::col::DESCRIPTION,
    sql::col::ATTRS,
    sql::col::ACQUIRED_BY,
    sql::col::ACQUIRED_AT,
    sql::col::RESOLVED_BY,
    sql::col::RESOLVED_AT,
    sql::col::RESOLUTION,
    sql::col::HIDDEN,
    sql::col::INTERNAL_CONTENT,
    sql::col::DEPLOYED_AT,
    sql::col::OBJECT_ID,
    sql::col::HASH_VALUE,
    sql::col::DUPLICATE_HEAD_ID,
    sql::col::VIEWED_BY,
    sql::col::STATE_MODIFIED_AT,
    sql::col::REJECT_REASON,
    sql::col::PROCESSING_LVL,
    sql::col::INDOOR_LEVEL,
};

const std::map<std::string, TransformFunc> FEEDBACK_TASK_FIELDS_TRANSFORMS {
    {
        sql::col::POSITION,
        [](const std::string& pos) {
            return sql::func::ST_ASBINARY + "(" + pos + ")";
        }
    }
};

std::vector<std::string>
createAliasedFieldsWithOptionalTransformForSelect(
    const std::vector<std::string>& fields,
    const std::map<std::string, TransformFunc> fieldTransforms,
    const std::string& tableAliasPrefix,
    const std::string& fieldAliasPrefix)
{
    auto aliased = fields;
    std::for_each(
        aliased.begin(), aliased.end(),
        [&](auto& field) {
            if (fieldTransforms.count(field)) {
                field = fieldTransforms.at(field)(tableAliasPrefix + field) + " AS " +
                        fieldAliasPrefix + field;
            } else {
                field = tableAliasPrefix + field + " AS " +
                        fieldAliasPrefix + field;

            }
        }
    );
    return aliased;
}

std::string
joinedFields(const std::vector<std::string>& fields)
{
    return common::join(fields, ',');
}

} // unnamed namespace

std::string feedbackTaskFields()
{
    return joinedFields(
        createAliasedFieldsWithOptionalTransformForSelect(
            FEEDBACK_TASK_FIELDS,
            FEEDBACK_TASK_FIELDS_TRANSFORMS,
            "ft.",
            FEEDBACK_TASK_FIELDS_PREFIX
        )
    );
}

} // namespace maps::wiki::social
