#include <yandex/maps/wiki/social/task.h>

#include "factory.h"
#include "magic_strings.h"

namespace maps::wiki::social {

Resolved::Resolved(const pqxx::row& row)
    : uid_(row[sql::col::RESOLVED_BY].as<TUid>())
{
    if (uid_) {
        date_ = row[sql::col::RESOLVED_AT].as<std::string>();
        REQUIRE(!date_.empty(), "empty 'resolved at' date, uid: " << uid_);

        resolution_ = boost::lexical_cast<ResolveResolution>(
            row[sql::col::RESOLVE_RESOLUTION].c_str());
    }
}

Closed::Closed(const pqxx::row& row)
    : uid_(row[sql::col::CLOSED_BY].as<TUid>())
{
    if (uid_) {
        date_ = row[sql::col::CLOSED_AT].as<std::string>();
        REQUIRE(!date_.empty(), "empty 'closed' date, uid: " << uid_);

        resolution_ = boost::lexical_cast<CloseResolution>(
            row[sql::col::CLOSE_RESOLUTION].c_str());
    }
}

Locked::Locked(const pqxx::row& row)
    : uid_(row[sql::col::LOCKED_BY].as<TUid>())
{
    if (uid_) {
        date_ = row[sql::col::LOCKED_AT].as<std::string>();
        REQUIRE(!date_.empty(), "empty 'locked' date, uid: " << uid_);
    }
}

Task::Task(const pqxx::row& row, Event event)
    : eventId_(row[sql::col::EVENT_ID].as<TId>())
    , commitId_(row[sql::col::COMMIT_ID].as<TId>(0))
    , event_(std::move(event))
    , resolved_(Factory::component<Resolved>(row))
    , closed_(Factory::component<Closed>(row))
    , locked_(Factory::component<Locked>(row))
{
}

} // namespace maps::wiki::social
