#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/task_filter.h>

#include <maps/wikimap/mapspro/libs/social/magic_strings.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/string_utils.h>


namespace maps::wiki::social {

std::string
TaskFilter::whereClause(pqxx::transaction_base& txn, const std::string& taskTableAlias) const
{
    std::string result = "TRUE";
    const std::string taskTable = taskTableAlias + '.';

    if (categories_) {
        result += " AND " + taskTable + sql::col::PRIMARY_OBJECT_CATEGORY_ID + " IN ('" + common::join(*categories_, "', '") + "')";
    }

    if (!resolvedBy_.empty()) {
        result += " AND " + taskTable + sql::col::RESOLVED_BY + " IN (" + common::join(resolvedBy_, ',') + ")";
    }
    if (resolvedAt_) {
        result += " AND " + resolvedAt_->sqlComparison(txn, taskTable + sql::col::RESOLVED_AT);
    }
    if (resolveResolution_) {
        const std::string value(toString(*resolveResolution_));
        result += " AND " + taskTable + sql::col::RESOLVE_RESOLUTION + " = '" + value + "'";
    }

    if (!closedBy_.empty()) {
        result += " AND " + taskTable + sql::col::CLOSED_BY + " IN (" + common::join(closedBy_, ',') + ")";
    }
    if (closedAt_) {
        result += " AND " + closedAt_->sqlComparison(txn, taskTable + sql::col::CLOSED_AT);
    }
    if (closeResolution_) {
        const std::string value(toString(*closeResolution_));
        result += " AND " + taskTable + sql::col::CLOSE_RESOLUTION + " = '" + value + "'";
    }

    return result;
}

} // namespace maps::wiki::social
