#include <yandex/maps/wiki/social/task_stats_console.h>
#include "tasks/stats.h"

namespace maps::wiki::social {

TaskStatsConsole::TaskStatsConsole(
    pqxx::transaction_base& work,
    ModerationMode mode
)
    : work_(work)
    , mode_(mode)
{}

TaskStatsConsole&
TaskStatsConsole::setFilterByCategories(CategoryIdsSet categoryIds)
{
    categoryIds_ = std::move(categoryIds);
    return *this;
}

TaskStatsConsole&
TaskStatsConsole::setFilterByEventType(EventType eventType)
{
    eventType_ = eventType;
    return *this;
}

std::map<TId, ActiveTaskStat>
TaskStatsConsole::activeTaskStatsByAoi(const ModerationTimeIntervals& moderationTimeIntervals) const
{
    return tasks::activeTaskStatsByAoi(work_, mode_, categoryIds_, eventType_, moderationTimeIntervals);
}

std::map<TId, size_t>
TaskStatsConsole::recentNewTaskCountsByAoi(const ModerationTimeIntervals& moderationTimeIntervals) const
{
    return tasks::recentNewTaskCountsByAoi(work_, mode_, categoryIds_, eventType_, moderationTimeIntervals);
}

std::map<TId, size_t>
TaskStatsConsole::recentProcessedTaskCountsByAoi(const ModerationTimeIntervals& moderationTimeIntervals) const
{
    return tasks::recentProcessedTaskCountsByAoi(work_, mode_, categoryIds_, eventType_, moderationTimeIntervals);
}

} // namespace maps::wiki::social
