#pragma once

#include <yandex/maps/wiki/social/event_filter.h>
#include <yandex/maps/wiki/social/moderation_console.h>
#include <yandex/maps/wiki/social/moderation_time_intervals.h>

#include <pqxx/pqxx>

namespace maps::wiki::social::tasks {

CountsByAoiCategoryId countsByAoiCategoryId(
    pqxx::transaction_base& work,
    TUid uid,
    ModerationMode mode,
    const EventFilter& eventFilter,
    const TIds& aoiIds,
    const ModerationTimeIntervals& moderationTimeIntervals);

bool existsAcquirable(
    pqxx::transaction_base& work,
    TUid uid,
    ModerationMode mode,
    const TIds& aoiIds,
    const ModerationTimeIntervals& moderationTimeIntervals);

} // namespace maps::wiki::social::tasks
