#include "defer.h"
#include <maps/wikimap/mapspro/libs/social/magic_strings.h>
#include <maps/wikimap/mapspro/libs/social/helpers.h>
#include <yandex/maps/wiki/common/string_utils.h>

namespace maps::wiki::social::tasks {

void
createDeferred(
    pqxx::transaction_base& work,
    TUid uid,
    const TaskIds& taskIds,
    const std::string& expiresAt)
{
    if (taskIds.empty()) {
        return;
    }

    std::vector<std::string> columns {
        sql::col::EVENT_ID,
        sql::col::DEFERRED_BY,
        sql::col::EXPIRES_AT
    };

    auto valuesMatrix = [&]() {
        std::vector<std::vector<std::string>> result;
        std::for_each(
            taskIds.begin(), taskIds.end(),
            [&](TId taskId) {
                result.push_back({
                    std::to_string(taskId),
                    std::to_string(uid),
                    work.quote(expiresAt)
                });
            }
        );
        return result;
    }();

    work.exec(
        "INSERT INTO " + sql::table::DEFERRED_TASK + " (" +
        common::join(columns, ',') + ") VALUES " +
        multirowValuesInsertStatement(valuesMatrix)
    );
}

} // namespace maps::wiki::social::tasks
