#include "get.h"

#include <maps/wikimap/mapspro/libs/social/magic_strings.h>
#include <yandex/maps/wiki/social/task.h>

namespace maps::wiki::social::tasks {

namespace {

TIds
getIds(const pqxx::result& rows) {
    TIds result;
    for (const auto& row: rows) {
        result.emplace(row[0].as<TId>());
    }
    return result;
}

TIds getTaskIds(
    pqxx::transaction_base& work,
    const TaskFilter& filter,
    const std::string& taskTableAlias)
{
    const std::string query =
        "SELECT " + sql::col::EVENT_ID + " "
        "FROM " + taskTableAlias + " "
        "WHERE " + filter.whereClause(work, taskTableAlias);

    return getIds(work.exec(query));
}

} // namespace

TIds
getAllActiveEditTasksCommitIds(
    pqxx::transaction_base& work)
{
    const std::string query =
        "SELECT " + sql::col::COMMIT_ID + " "
        "FROM " + sql::table::TASK_ACTIVE + " "
        "WHERE " + sql::col::TYPE + " = '" + sql::value::EVENT_TYPE_EDIT + "'";

    return getIds(work.exec(query));
}

TIds getTaskIds(
    pqxx::transaction_base& work,
    const TaskFilter& filter)
{
    return getTaskIds(work, filter, sql::table::TASK);
}

TIds
getTaskIdsResolvedAt(
    pqxx::transaction_base& work,
    DateTimeCondition resolvedAt)
{
    TaskFilter filter;
    filter.setResolvedAt(resolvedAt);
    return getTaskIds(work, filter, sql::table::TASK);
}

TIds
getTaskIdsClosedAt(
    pqxx::transaction_base& work,
    DateTimeCondition closedAt)
{
    TaskFilter filter;
    filter.setClosedAt(closedAt);
    return getTaskIds(work, filter, sql::table::TASK_CLOSED);
}

} // namespace maps::wiki::social::tasks
