#pragma once

#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/social/task_feed.h>
#include <yandex/maps/wiki/social/task_filter.h>
#include <yandex/maps/wiki/social/date_time_condition.h>

#include <optional>

namespace maps::wiki::social::tasks {

enum class LoadingTaskMode
{
    Active,
    Closed,
    All
};

Tasks loadAllByTaskIds(
    pqxx::transaction_base& work,
    const TaskIds& taskIds,
    LoadingTaskMode taskMode);

Tasks loadEditsByCommitIds(
    pqxx::transaction_base& work,
    const TIds& commitIds,
    LoadingTaskMode taskMode);

Tasks loadAllActiveEditTasks(
    pqxx::transaction_base& work);

TaskFeed load(
    pqxx::transaction_base& work,
    const TaskFeedParams& params,
    const TaskFilter& filter);

} // namespace maps::wiki::social::tasks
